#ifndef _PAD_H
#define _PAD_H

#include <string.h>
#include "PSoCAPI.h"    // PSoC API definitions for all User Modules

void pad_ConsoleWrite(char *str);
void pad_ConsoleWriteC(const char *cstr);
void pad_ConsoleWriteInt(int v, unsigned char len);

void pad_LcdClear(void);
void pad_LcdPrintC(unsigned char x, unsigned char y, unsigned char font, const char *s);
void pad_LcdPrint(unsigned char x, unsigned char y, unsigned char font,  char *str);
void pad_waitButtonRelease(void);
void pad_setAllowHostWhenIdle(unsigned char v);

unsigned char pad_chksend(unsigned char chk, unsigned char c);
unsigned char pad_chksend_cstring(unsigned char chk, const char *s);
unsigned char pad_chksend_string(unsigned char chk, char *s);

unsigned char pad_pollButtons(void);
unsigned char pad_gets(void);
void pad_waitButtonRelease(void);
unsigned char pad_currentButtons(void);

void pad_idle(void);

#define PAD_IDLE  0
#define PAD_UP    1
#define PAD_DOWN  2
#define PAD_RIGHT 3
#define PAD_LEFT  4

#define PAD_MOVEMASK 0xf

#define PAD_STICK 0x10
#define PAD_MENU  0x20
#define PAD_STOP  0x40

#endif